
#ifndef _SERVER_SOCKET_H_
#define _SERVER_SOCKET_H_

#include <glibmm.h>
#include <thread>
#include <unistd.h>
#include <signal.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>      /* for UNIX sockets */

#define PROTOCOL 0       /* protocol by default */

class serverSocket
{
public:
	serverSocket(const std::vector<std::string>&);
	virtual ~serverSocket();
  
private:
	Glib::Threads::Thread *thread;
	
	std::string fileDescriptor;
	int dfServer, dfClient; 
	socklen_t longServer, longClient; 

	struct sockaddr_un dirUNIXServer;  
	struct sockaddr_un dirUNIXClient;  

	struct sockaddr* puntSockServer;  
	struct sockaddr* puntSockClient;
	
	void send_messages(std::vector<std::string>); 
};

#endif // _SERVER_SOCKET_H_
