
#include <iostream>
#include <string>
#include <vector>
#include "server_socket.h"

serverSocket::serverSocket(const std::vector<std::string> &args)
{
	std::vector<std::string> messages;
	
	for (const std::string &str : args)
		messages.push_back(str);

	sigc::slot<void>
		op_send = sigc::bind< std::vector<std::string> >
				(
					sigc::mem_fun(*this, &serverSocket::send_messages),
					messages
				);  
  
	thread = Glib::Threads::Thread::create(op_send);
}

serverSocket::~serverSocket()
{
	if(thread) {
				thread->join();
				thread = nullptr;
	}
}

void serverSocket::send_messages(std::vector<std::string> messages)
{
	puntSockServer = (struct sockaddr*) &dirUNIXServer;  
	longServer = sizeof(dirUNIXServer);  
	puntSockClient = (struct sockaddr*) &dirUNIXClient;  
	longClient = sizeof(dirUNIXClient);
	   
	signal(SIGCHLD, SIG_IGN);    /*  avoid zombies */
	
	std::vector<std::string>::iterator iter;
	iter = messages.begin();
	
	// Create a bidirectional UNIX socket:
	dfServer = socket ( AF_UNIX, SOCK_STREAM, PROTOCOL );                   
	dirUNIXServer.sun_family = AF_UNIX;   /* domain type */      
	strcpy(dirUNIXServer.sun_path, (*iter).c_str());   /* name of the client */  
	unlink((*iter).c_str()); 
	 
	// Create the file descriptor, that is, the socket: 
	bind(dfServer, puntSockServer, longServer);
                                          
	// Wait for the request of the client: 
	listen(dfServer, 5);  
  
	// Accept the connection
	dfClient = accept(dfServer, puntSockClient, &longClient);

	// create the child and send the file descriptor
	iter++;
	if (fork() == 0)   
	{
		for (iter; iter < messages.end(); iter++)
			write(dfClient, (*iter).c_str(), strlen((*iter).c_str()) + 1);	 
		 
		close(dfClient);        // close the socket  
		exit(0);    
	}
        
	close(dfClient);      /* close the file descriptor in the parent */ 	
}

                              	


