 
#include "client_socket.h"

clientSocket::clientSocket(std::string fileDescriptor)
{
	puntSockServer = (struct sockaddr*) &dirUNIXServer;  
	longServer = sizeof(dirUNIXServer);
	
	// Create a bidirectional UNIX socket:
	dfClient = socket ( AF_UNIX, SOCK_STREAM, PROTOCOL );
	dirUNIXServer.sun_family = AF_UNIX;    /* domain type */  
	strcpy(dirUNIXServer.sun_path, fileDescriptor.c_str());   /* name of the server */

	int n=0;
	while(1) {  
		int result = connect(dfClient, puntSockServer, longServer);  
		if(result == -1 && n<10) {
			sleep (1);   /* retry */
			n++;
		} else break;
	}
	
	/* close the file descriptor */
	std::vector<std::string>::iterator iter;
	iter = messages.begin();	
	while(readMessage()) iter++;  
	
	close(dfClient);      /* close the socket */
}

clientSocket::~clientSocket()
{
	
}

int clientSocket::readMessage()
{
	char *buffer, *cad;
	
	buffer = (char*)malloc(1);
	buffer[0] = '\0';
		
	cad = (char*)malloc(1);
	cad[0] = '\0';
	
	int n, buffer_size = 1, len = 0;
	
	do {						
		n = read (dfClient, cad, 1);
		
		if (buffer_size <= len + 1) {
			buffer_size = buffer_size * 2 + 16;
			buffer = (char*)realloc(buffer, buffer_size);
		}
	
		buffer[len++] = *cad;
		buffer[len] = 0;
		
	} while (n > 0 && *cad++ != NULL);	
	
	if(n > 0) messages.push_back(buffer);
	
	free(buffer);
	
	return (n > 0);
}
