/*
 * window_main.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * gkexec is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gkexec is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include "window_main.h"
#include "buttonbox.h"
#include <iostream>

WindowMain::WindowMain(char **argv)
: m_bActivityMode(true)
{  
	set_size_request( 500, 220 );
  
	m_Label.set_text( "\nEnter the password:" ); 
  
	set_title( "Password dialog" );
	set_position( Gtk::WIN_POS_CENTER );

	// As a GtkBin subclass a gtkmm__GtkDialog can only contain one widget at a time,
	// it already contains a widget of type Gtk::HBox:
	 
	m_VBox = new Gtk::VBox();
	// In gtkmm3, it should be:
	// m_VBox = get_content_area();
	m_VBox=get_vbox();
 
	m_VBox->add( m_Label );
	m_VBox->add( m_Entry );
   
	m_Entry.set_visibility( false );  
	const std::string text= " Show password ";
  
	bool mnemonic = false;
	
	myButtonBox *pButtonBox = new myButtonBox(true, 3, Gtk::BUTTONBOX_CENTER);
    m_VBox->pack_start(*pButtonBox, true, true, 5);	
	 
	m_CheckButton_Visible = new Gtk::CheckButton( text, mnemonic );  
	pButtonBox->bbox->add( *m_CheckButton_Visible );
    
	m_Button_Close = Gtk::manage( new Gtk::Button(Gtk::Stock::CLOSE));
	pButtonBox->bbox->add( *m_Button_Close );
	
	m_Button_Execute = Gtk::manage( new Gtk::Button(Gtk::Stock::EXECUTE));
	pButtonBox->bbox->add( *m_Button_Execute );
 
	m_Entry.select_region(0, m_Entry.get_text_length());
	m_CheckButton_Visible->set_active(false);
              
	m_Button_Execute->set_can_default();   
	
	m_Button_Close->signal_clicked().connect
	(
		sigc::mem_fun(*this, &WindowMain::on_button_close)
	);   
	
	m_Button_Execute->signal_clicked().connect
	(
		sigc::bind<char**>
		(
			sigc::mem_fun(*this, &WindowMain::on_button_execute),
			argv
		)
	);  
	      
	m_CheckButton_Visible->signal_toggled().connect
	(
		sigc::mem_fun(*this, &WindowMain::on_checkbox_visibility_toggled)
	);

	show_all_children();
	m_Button_Execute->grab_default();
	
}

// Destructor
WindowMain::~WindowMain()
{

}

void WindowMain::clear_entry_box()
{
	m_Entry.set_text("");
}

void WindowMain::on_checkbox_visibility_toggled()
{
	m_Entry.set_visibility( m_CheckButton_Visible->get_active() );
}

void WindowMain::on_button_close()
{
	hide();
}

void WindowMain::on_button_execute(char **argv)
{
	std::string passwd=m_Entry.get_text();
	setenv("SUDO_ASKPASS", passwd.c_str(), 1);
	std::cout << passwd << std::endl;
	hide();
}

